-- Deploy update-country-airport-count

BEGIN;

CREATE OR REPLACE FUNCTION "update-country-airport-count"() RETURNS int AS $$
DECLARE
  row_count int := 0;
BEGIN
  UPDATE countries
     SET "airport-count" = u.count
    FROM (SELECT countries.id, count(airports.id)
            FROM countries
       LEFT JOIN airports
              ON airports."country-id" = countries.id
        GROUP BY countries.id) AS u
   WHERE countries.id = u.id;
  GET DIAGNOSTICS row_count = ROW_COUNT;
  RETURN row_count;
END;
$$ LANGUAGE plpgsql;

COMMIT;
