-- Deploy eu-value

BEGIN;

CREATE OR REPLACE FUNCTION "eu-value"(value DOUBLE PRECISION, unit TEXT)
RETURNS DOUBLE PRECISION AS $$
BEGIN
  CASE unit
  WHEN 'k' THEN
    RETURN "kelvin->celsius"(value);
  WHEN 'm/s' THEN
    RETURN "m/s->km/h"(value);
  ELSE
    RETURN value;
  END CASE;
END;
$$ LANGUAGE plpgsql IMMUTABLE STRICT;

COMMIT;
