-- Deploy create-weather-models-table

BEGIN;

CREATE TABLE "weather"."models" (
  "id" SERIAL PRIMARY KEY,
  "name" CITEXT NOT NULL,
  "description" TEXT NOT NULL,
  "dods" TEXT NOT NULL,
  "res-x" FLOAT NOT NULL,
  "res-y" FLOAT NOT NULL,
  "latest-reference-time" TIMESTAMP WITH TIME ZONE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX "weather-models-name-fulltext-index" ON "weather"."models" USING gin(to_tsvector('english', "name"));

CREATE TRIGGER "weather-models-created-at-trigger"
  BEFORE INSERT ON "weather"."models" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "weather-models-updated-at-trigger"
  BEFORE UPDATE ON "weather"."models" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
