-- Deploy create-raster-table

BEGIN;

ALTER TABLE "weather"."datasets" DROP COLUMN "rast";

CREATE TABLE "weather"."rasters" (
  "id" SERIAL PRIMARY KEY,
  "dataset-id" INTEGER NOT NULL REFERENCES "weather"."datasets"("id") ON DELETE CASCADE,
  "rast" raster,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX "weather-rasters-rast-idx" ON "weather"."rasters" USING GIST (ST_ConvexHull("rast"));

CREATE TRIGGER "weather-rasters-created-at-trigger"
  BEFORE INSERT ON "weather"."rasters" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "weather-rasters-updated-at-trigger"
  BEFORE UPDATE ON "weather"."rasters" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
