-- Deploy convert-value

BEGIN;

CREATE OR REPLACE FUNCTION "convert-value"(value DOUBLE PRECISION, unit TEXT, target TEXT)
RETURNS DOUBLE PRECISION AS $$
BEGIN
  CASE target
  WHEN 'eu' THEN
    RETURN "eu-value"(value, unit);
  WHEN 'uk' THEN
    RETURN "uk-value"(value, unit);
  WHEN 'us' THEN
    RETURN "us-value"(value, unit);
  ELSE
    RETURN value;
  END CASE;
END;
$$ LANGUAGE plpgsql IMMUTABLE STRICT;

COMMIT;
