-- Deploy airport-count-trigger

BEGIN;

CREATE OR REPLACE FUNCTION "update-airport-counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update-continent-airport-count"();
  PERFORM "update-country-airport-count"();
  PERFORM "update-region-airport-count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update-airport-counts-on-delete-trigger"
  AFTER DELETE ON "airports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-airport-counts"();

CREATE TRIGGER "update-airport-counts-on-insert-trigger"
  AFTER INSERT ON "airports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-airport-counts"();

CREATE TRIGGER "update-airport-counts-on-update-trigger"
  AFTER UPDATE ON "airports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-airport-counts"();

COMMIT;
