-- Deploy port-count-trigger

BEGIN;

CREATE OR REPLACE FUNCTION "update-port-counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update-continent-port-count"();
  PERFORM "update-country-port-count"();
  PERFORM "update-region-port-count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update-port-counts-on-delete-trigger"
  AFTER DELETE ON "ports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-port-counts"();

CREATE TRIGGER "update-port-counts-on-insert-trigger"
  AFTER INSERT ON "ports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-port-counts"();

CREATE TRIGGER "update-port-counts-on-update-trigger"
  AFTER UPDATE ON "ports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-port-counts"();

COMMIT;
