-- Deploy region-count-trigger

BEGIN;

CREATE OR REPLACE FUNCTION "update-region-counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update-continent-region-count"();
  PERFORM "update-country-region-count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update-region-counts-on-delete-trigger"
  AFTER DELETE ON "regions"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-region-counts"();

CREATE TRIGGER "update-region-counts-on-insert-trigger"
  AFTER INSERT ON "regions"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-region-counts"();

CREATE TRIGGER "update-region-counts-on-update-trigger"
  AFTER UPDATE ON "regions"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-region-counts"();

COMMIT;
