-- Deploy create-region-forecasts

BEGIN;

CREATE TABLE "weather"."region-forecasts" (
  "id" SERIAL PRIMARY KEY,
  "region-id" INTEGER NOT NULL REFERENCES "regions"("id") ON DELETE CASCADE,
  "variable-id" INTEGER NOT NULL REFERENCES "weather"."variables"("id") ON DELETE CASCADE,
  "valid-time" TIMESTAMP WITH TIME ZONE NOT NULL,
  "value" FLOAT,
  "avg-value" FLOAT,
  "min-value" FLOAT,
  "max-value" FLOAT,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE UNIQUE INDEX "weather-region-forecasts-region-id-valid-time-variable-id-index" ON "weather"."region-forecasts" ("region-id", "valid-time", "variable-id");

CREATE TRIGGER "weather-region-forecasts-created-at-trigger"
  BEFORE INSERT ON "weather"."region-forecasts" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "weather-region-forecasts-updated-at-trigger"
  BEFORE UPDATE ON "weather"."region-forecasts" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
