-- Deploy add-time-zone-id-to-spots

BEGIN;

ALTER TABLE "spots" ADD COLUMN "time-zone-id" INTEGER REFERENCES "time-zones" ("id") ON DELETE SET NULL;

UPDATE spots
   SET "time-zone-id" = t.id
  FROM (SELECT "time-zones".id, spots.id AS "spot-id"
          FROM "time-zones"
          JOIN spots
            ON ST_Contains("time-zones"."geom", spots.location)) AS t
  WHERE spots.id = t."spot-id";

COMMIT;
