(ns burningswell.db.connection
  (:require [datumbazo.core :as d]
            [datumbazo.driver.core :as driver]
            [datumbazo.io :as io]))

(defn new-db [config & [opts]]
  (d/new-db config (merge opts {:backend 'jdbc.core})))

(defmacro with-db
  "Eval `body` within the context of a database."
  [[db-sym config] & body]
  `(d/with-db [~db-sym ~config {:backend 'jdbc.core}]
     ~@body))

(comment
  (require '[environ.core :refer [env]])
  (require '[burningswell.config.core :as config])
  (with-db [db (assoc (config/db env) :name "burningswell_test")]
    (burningswell.db.spots/set-timezone db)))
