-- Deploy create-roles-table

BEGIN;

CREATE TABLE "roles" (
  "id" SERIAL PRIMARY KEY,
  "name" CITEXT NOT NULL UNIQUE,
  "description" CITEXT NOT NULL UNIQUE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX "roles-name-fulltext-index" ON "roles" USING gin(to_tsvector('english', "name"));

CREATE TRIGGER "roles-created-at-trigger"
  BEFORE INSERT ON "roles" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "roles-updated-at-trigger"
  BEFORE UPDATE ON "roles" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
