(ns burningswell.db.time-zones
  (:refer-clojure :exclude [distinct group-by update])
  (:require [burningswell.db.schemas :refer :all]
            [burningswell.db.util :refer :all]
            [datumbazo.core :as sql :exclude [delete insert update] :refer :all]
            [schema.core :as s])
  (:import sqlingvo.db.Database
           org.postgis.Point))

(defn- select-all [db & [opts]]
  (let [{:keys [page per-page]} opts]
    (select db [:time-zones.id
                :time-zones.natural-earth-id
                :time-zones.offset
                :time-zones.places
                :time-zones.created-at
                :time-zones.updated-at]
      (from :time-zones)
      (paginate page per-page))))

(s/defn all :- [TimeZone]
  "Return all time zones in `db`."
  [db :- Database & [opts]]
  @(select-all db opts))

(s/defn by-id :- (s/maybe TimeZone)
  "Return the time zone in `db` by `id`."
  [db :- Database id :- s/Int & [opts]]
  (first @(compose
           (select-all db opts)
           (where `(= :time-zones.id (cast ~id :integer))))))

(s/defn by-location :- (s/maybe TimeZone)
  "Return the time zone in `db` for `location`."
  [db :- Database location :- Point & [opts]]
  (first @(compose
           (select-all db opts)
           (where `(st_intersects
                    :time-zones.geom
                    (cast ~location :geography))))))
