-- Deploy create-regions-table

BEGIN;

CREATE TABLE "regions" (
  "id" SERIAL PRIMARY KEY,
  "country-id" INTEGER NOT NULL REFERENCES "countries"("id") ON DELETE CASCADE,
  "name" CITEXT NOT NULL,
  "geom" GEOMETRY(MULTIPOLYGON, 4326),
  "airport-count" INTEGER NOT NULL DEFAULT 0,
  "port-count" INTEGER NOT NULL DEFAULT 0,
  "spot-count" INTEGER NOT NULL DEFAULT 0,
  "user-count" INTEGER NOT NULL DEFAULT 0,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX "regions-name-fulltext-index" ON "regions" USING gin(to_tsvector('english', "name"));
CREATE INDEX "regions-geom-index" ON "regions" USING gist("geom");

CREATE TRIGGER "regions-created-at-trigger"
  BEFORE INSERT ON "regions" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "regions-updated-at-trigger"
  BEFORE UPDATE ON "regions" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
