-- Deploy create-spots-users-table

BEGIN;

CREATE TABLE "spots-users" (
  "spot-id" INTEGER NOT NULL REFERENCES spots(id) ON DELETE CASCADE,
  "user-id" INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE UNIQUE INDEX "spots-users-spot-id-user-id-index" ON "spots-users"("spot-id", "user-id");

CREATE TRIGGER "spots-users-created-at-trigger"
  BEFORE INSERT ON "spots-users" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "spots-users-updated-at-trigger"
  BEFORE UPDATE ON "spots-users" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
