(ns burningswell.db.weather.forecasts
  (:refer-clojure :exclude [distinct group-by update])
  (:require [burningswell.db.schemas :refer :all]
            [burningswell.db.util :refer :all]
            [datumbazo.core :as sql :exclude [delete insert update] :refer :all]
            [schema.core :as s])
  (:import sqlingvo.db.Database))

(defn- select-all [db & [opts]]
  (select db [:weather.forecasts.id
              :weather.forecasts.status
              :weather.forecasts.created-at
              :weather.forecasts.updated-at]
    (from :weather.forecasts)
    (paginate (:page opts) (:per-page opts))))

(defn- pk-clause [forecast]
  `(= :weather.forecasts.model-id
      ~(:id forecast)))

(defn- row [forecast]
  (select-keys forecast [:id :status]))

(s/defn by-id :- (s/maybe WeatherForecast)
  "Return the weather forecast in `db` by `id`."
  [db :- Database id :- s/Int]
  (first @(compose
           (select-all db)
           (where `(= :weather.forecasts.id (cast ~id :integer))))))

(s/defn insert :- WeatherForecast
  "Insert `forecast` into `db`."
  [db :- Database forecast]
  (->> @(sql/insert db :weather.forecasts []
          (values [(row forecast)])
          (returning :id))
       first :id (by-id db)))

(s/defn update :- (s/maybe WeatherForecast)
  "Update `forecast` in `db`."
  [db :- Database forecast]
  (->> @(sql/update db :weather.forecasts
          (row forecast)
          (where (pk-clause forecast))
          (returning :id))
       first :id (by-id db)))

(s/defn save :- WeatherForecast
  "Update `forecast` in `db`."
  [db :- Database forecast]
  (or (update db forecast)
      (insert db forecast)))
