(defproject burningswell/core "0.0.88"
  :description "The Burning Swell core library"
  :url "https://github.com/burningswell/core"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :min-lein-version "2.0.0"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[bidi "2.1.5"]
                 [cheshire "5.8.1"]
                 [clj-http "3.9.1"]
                 [clj-time "0.15.1"]
                 [com.stuartsierra/component "0.4.0"]
                 [enlive "1.1.6"]
                 [environ "1.1.0"]
                 [geo-clj "0.6.3"]
                 [hal-clj "0.1.14"]
                 [net.postgis/postgis-jdbc "2.3.0" :exclusions [postgresql org.postgresql/postgresql]]
                 [noencore "0.3.6"]
                 [ns-tracker "0.3.1"]
                 [org.clojure/clojure "1.10.0"]
                 [org.clojure/clojurescript "1.10.520" :scope "provided"]
                 [org.clojure/data.json "0.2.6"]
                 [org.clojure/test.check "0.9.0"]
                 [org.clojure/tools.logging "0.5.0-alpha.1"]
                 [org.clojure/tools.namespace "0.2.10"]
                 [org.postgresql/postgresql "42.2.5"]]
  :plugins [[lein-environ "1.1.0"]
            [lein-doo "0.1.11"]]
  :aliases {"ci" ["do"
                  ["difftest"]
                  ["test-cljs"]
                  ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]
            "test-cljs" ["do"
                         ["doo" "node" "none" "once"]
                         ["doo" "node" "advanced" "once"]]
            "test-ancient" ["test"]}
  :cljsbuild {:builds [{:id "none"
                        :compiler
                        {:main burningswell.test-runner
                         :optimizations :none
                         :output-dir "target/none"
                         :output-to "target/none-test.js"
                         :target :nodejs}
                        :source-paths ["src" "test"]}
                       {:id "advanced"
                        :compiler
                        {:main burningswell.test-runner
                         :optimizations :advanced
                         :output-dir "target/advanced"
                         :output-to "target/advanced-test.js"
                         :target :nodejs}
                        :source-paths ["src" "test"]}]}
  :profiles {:dev {:plugins [[jonase/eastwood "0.3.5"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]}}
  :uberjar-name "burningswell-core.jar")
