(ns burningswell.string
  (:require [clojure.string :as str]
            [no.en.core :refer [parse-integer]]))

(defn trim-if [s]
  (if s (str/trim s)))

(defn capitalize-sentence [sentence]
  (if sentence
    (str/join " " (map str/capitalize (str/split sentence #"\s+")))))

(defn parse-id [s]
  (if-let [id (re-find #"(?i)[0-9]+" (str s))]
    (parse-integer id)))

(defn- parse-alpha-numeric-id [s n]
  (if-let [s (re-find (re-pattern (str "^(?i)[a-z]{" n "," n "}")) (str s))]
    (str/lower-case s)))

(defn parse-iata-code
  "Parse the string and return the IATA code."
  [s]
  (if-let [matches (re-matches #"^(?i)([a-z]{3,3})(-.*)?" (str s))]
    (str/upper-case (nth matches 1))))

(defn parse-iso-639-1
  "Parse the string and return the ISO-639-1 language code."
  [s] (parse-alpha-numeric-id s 2))

(defn parse-iso-639-2
  "Parse the string and return the ISO-639-2 language code."
  [s] (parse-alpha-numeric-id s 3))

(defn parse-iso-3166-1-alpha-2
  "Parse the string and return the ISO-3166-1 alpha-2 country code."
  [s] (parse-alpha-numeric-id s 2))

(defn parse-iso-3166-1-alpha-3
  "Parse the string and return the ISO-3166-1 alpha-3 country code."
  [s] (parse-alpha-numeric-id s 3))

(defn parse-iso-3166-2-code
  "Parse the string and return the ISO-3166-2 code."
  [s]
  (if-let [s (first (re-find #"(?i)([a-z]+(\-[a-z0-9]+)?)" (str s)))]
    (str/lower-case s)))
