(ns burningswell.routes
  (:require [bidi.bidi :as bidi]
            [no.en.core :refer [format-url]]))

(def ^:private params
  {:name [#".*" :name]
   :id [#"\d+" :id]})

(def ^:private slug-id-name
  ["/" (:id params) "-" (:name params)])

(def routes
  "The Burning Swell web routes."
  ["/"
   {"" :home

    "airports"
    {"" :airports
     slug-id-name :airport}

    "continents"
    {"" :continents
     slug-id-name :continent}

    "countries"
    {"" :countries
     slug-id-name :country}

    "graphql" :graphql

    "ports"
    {"" :ports
     slug-id-name :port}

    "regions"
    {"" :regions
     slug-id-name :region}

    "oauth"
    {"" :oauth
     ["/" (:name params) "/callback"] :oauth-callback
     ["/" (:name params) "/connect"] :oauth-connect}

    "state" :state
    "settings" :settings
    "signin" :signin
    "signout" :signout
    "signup" :signup

    "spots"
    {"" :spots
     slug-id-name :spot}

    "users"
    {"" :users
     slug-id-name :user}

    "weather/models"
    {"" :weather-models
     slug-id-name :weather-model}

    "weather/variables"
    {"" :weather-variables
     slug-id-name :weather-variable}}])

(defn match [path & opts]
  (some-> (apply bidi/match-route routes path opts)
          (assoc :uri path)))

(defn path [handler & opts]
  (apply bidi/path-for routes handler opts))

(defn url [client handler & opts]
  (->> (apply path handler opts)
       (assoc client :uri)))

(defn url-str [client handler & opts]
  (format-url (apply url client handler opts)))
