(ns burningswell.io
  (:require [clojure.java.io :as io])
  (:import [java.io ByteArrayInputStream ByteArrayOutputStream]))

(defn slurp-byte-array
  "Read `source` and return it as a byte array."
  [source]
  (let [output (ByteArrayOutputStream.)]
    (with-open [input (io/input-stream source)]
      (io/copy input output))
    (.toByteArray output)))

(defn spit-byte-array
  "Spit the `byte-array` to `file`."
  [file byte-array]
  (let [input (ByteArrayInputStream. byte-array)]
    (with-open [output (io/output-stream file)]
      (io/copy input output))))
