(defproject burningswell/core "0.0.61"
  :description "The Burning Swell core library"
  :url "https://github.com/burningswell/core"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :min-lein-version "2.0.0"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[bidi "2.1.3"]
                 [cheshire "5.8.0"]
                 [clj-http "3.7.0"]
                 [clj-time "0.14.2"]
                 [com.stuartsierra/component "0.3.2"]
                 [enlive "1.1.6"]
                 [environ "1.1.0"]
                 [geo-clj "0.6.2"]
                 [geonames "0.6.8"]
                 [hal-clj "0.1.13"]
                 [net.postgis/postgis-jdbc "2.2.1" :exclusions [postgresql org.postgresql/postgresql]]
                 [noencore "0.3.4"]
                 [ns-tracker "0.3.1"]
                 [org.clojure/clojure "1.9.0"]
                 [org.clojure/data.json "0.2.6"]
                 [org.clojure/test.check "0.9.0"]
                 [org.clojure/tools.logging "0.4.0"]
                 [org.clojure/tools.namespace "0.2.10"]
                 [org.postgresql/postgresql "42.2.1"]]
  :plugins [[lein-environ "1.1.0"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]
            "test-ancient" ["test"]}
  :profiles {:dev {:plugins [[jonase/eastwood "0.2.5"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]}}
  :uberjar-name "burningswell-core.jar")
