(ns burningswell.routes
  (:require [bidi.bidi :as bidi]))

(def routes
  "The Burning Swell web routes."
  ["/"
   {"" :home

    "continents"
    {"" :continents
     ["/" [#"\d+" :id] "-" :name] :continent}

    "countries"
    {"" :countries
     ["/" [#"\d+" :id] "-" :name] :country}

    "graphql" :graphql

    "regions"
    {"" :regions
     ["/" [#"\d+" :id] "-" :name] :region}


    "oauth/providers"
    {"" :oauth-providers
     ["/" :name] :oauth-provider
     ["/" :name "/callback"] :oauth-provider-callback
     ["/" :name "/connect"] :oauth-provider-connect}

    "state" :state
    "settings" :settings
    "signin" :signin
    "signout" :signout
    "signup" :signup

    "spots"
    {"" :spots
     ["/" [#"\d+" :id] "-" :name] :spot}

    "users"
    {"" :users
     ["/" [#"\d+" :id] "-" :name] :user}

    "weather/models"
    {"" :weather-models
     ["/" [#"\d+" :id] "-" :name] :weather-model}

    "weather/variables"
    {"" :weather-variables
     ["/" [#"\d+" :id] "-" :name] :weather-variable}}])

(defn match [path & opts]
  (some-> (apply bidi/match-route routes path opts)
          (assoc :uri path)))

(defn path [handler & opts]
  (apply bidi/path-for routes handler opts))
