(ns burningswell.check
  (:require [clojure.test.check :as tc]
            [clojure.test.check.generators :as gen]
            [clojure.test.check.properties :as prop]))

(def gender
  "Generate genders."
  (gen/elements ["male" "female"]))

(def domain
  "Generate domain names."
  (gen/elements ["gmail.com" "hotmail.com" "computer.org"]))

(def username
  "Generate user names."
  (gen/not-empty gen/string-alphanumeric))

(def email
  "Generate email addresses."
  (gen/fmap
   (fn [[name domain]] (str name "@" domain))
   (gen/tuple username domain)))
