(ns burningswell.config.test
  "The Burning Swell test configuration."
  (:require #?(:clj [environ.core :as env])))

(def env
  "The test environment."
  (merge
   {:bs-api-bind-address "127.0.0.1"
    :bs-api-bind-port "9000"
    :bs-api-scheme "http"
    :bs-api-server-name "localhost"
    :bs-api-server-port "9000"
    :bs-api-ssl-redirect "false"
    :bs-aws-access-key "AWS-ACCESS-KEY"
    :bs-aws-account-number "AWS-ACCOUNT-NUMBER"
    :bs-aws-secret-key "AWS-SECRET-KEY"
    :bs-broker-server-name "localhost"
    :bs-broker-server-port "5672"
    :bs-broker-username "tiger"
    :bs-figwheel-enable "false"
    :bs-image-proxy-backend-url "https://s3.amazonaws.com/burningswell-test"
    :bs-image-proxy-bind-address "127.0.0.1"
    :bs-image-proxy-bind-port "22002"
    :bs-image-proxy-scheme "http"
    :bs-image-proxy-server-name "localhost"
    :bs-image-proxy-server-port "22002"
    :bs-broker-password "scotch"
    :bs-broker-vhost "burningswell.test"
    :bs-datomic-url "datomic:mem://burningswell-test"
    :bs-db-name "burningswell_test"
    :bs-db-password "scotch"
    :bs-db-test "true"
    :bs-db-scheme "postgresql"
    :bs-db-server-name "localhost"
    :bs-db-server-port "5432"
    :bs-db-user "tiger"
    :bs-facebook-client-id "FACEBOOK-CLIENT-ID"
    :bs-facebook-client-secret "FACEBOOK-CLIENT-SECRET"
    :bs-facebook-redirect-uri
    "http://api.burningswell.dev/oauth/facebook/callback"
    :bs-flickr-api-key "FLICKR-API-KEY"
    :bs-flickr-client-id "FLICKR-CLIENT-ID"
    :bs-flickr-client-secret "FLICKR-CLIENT-SECRET"
    :bs-google-analytics-tracking-id "TRACKING-ID"
    :bs-google-api-key "GOOGLE-API-KEY"
    :bs-google-client-id "GOOGLE-CLIENT-ID"
    :bs-google-client-secret "GOOGLE-CLIENT-SECRET"
    :bs-google-redirect-uri "http://api.burningswell.dev/oauth/google/callback"
    :bs-google-maps-api-key "GOOGLE-MAPS-API-KEY"
    :bs-google-storage-bucket "burningswell-test"
    :bs-jwt-secret "secret"
    :bs-linkedin-client-id "LINKEDIN-CLIENT-ID"
    :bs-linkedin-client-secret "LINKEDIN-CLIENT-SECRET"
    :bs-mapbox-api-key "MAPBOX-API-KEY"
    :bs-mapbox-style "mapbox://styles/mapbox/light-v8"
    :bs-reload-disabled "true"
    :bs-s3-backup-bucket "burningswell-test"
    :bs-s3-backup-prefix "backups"
    :bs-s3-photo-bucket "burningswell-test"
    :bs-s3-photo-prefix "photos"
    :bs-twitter-client-id "TWITTER-CLIENT-ID"
    :bs-twitter-client-secret "TWITTER-CLIENT-SECRET"
    :bs-weather-bind-address "127.0.0.1"
    :bs-weather-bind-port "22003"
    :bs-web-bind-address "127.0.0.1"
    :bs-web-bind-port "9001"
    :bs-web-scheme "http"
    :bs-web-server-name "localhost"
    :bs-web-server-port "9001"
    :bs-web-ssl-redirect "false"
    :bs-worker-bind-port "9003"}
   #?(:clj env/env)))
