(defproject burningswell/config "0.1.33"
  :description "The Burning Swell configuration"
  :url "https://github.com/burningswell/config"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :min-lein-version "2.0.0"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[environ "1.1.0"]
                 [org.clojure/clojure "1.8.0"]
                 [org.clojure/clojurescript "1.9.93" :scope "provided"]
                 [prismatic/schema "1.1.3"]]
  :aliases {"ci" ["do"
                  ["difftest"]
                  ["doo" "node" "none" "once"]
                  ["doo" "node" "advanced" "once"]
                  ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]
            "test-ancient" ["test"]}
  :cljsbuild {:builds [{:id "none"
                        :compiler
                        {:main burningswell.config.test-runner
                         :optimizations :none
                         :output-dir "target/none"
                         :output-to "target/none-test.js"
                         :target :nodejs}
                        :source-paths ["src" "test"]}
                       {:id "advanced"
                        :compiler
                        {:main burningswell.config.test-runner
                         :optimizations :advanced
                         :output-dir "target/advanced"
                         :output-to "target/advanced-test.js"
                         :target :nodejs}
                        :source-paths ["src" "test"]}]}
  :eastwood {:exclude-linters [:constant-test]}
  :profiles {:dev {:plugins [[jonase/eastwood "0.2.3"]
                             [lein-cljsbuild "1.1.2"]
                             [lein-difftest "2.0.0"]
                             [lein-doo "0.1.6"]
                             [listora/whitespace-linter "0.1.0"]]}
             :repl {:dependencies [[com.cemerick/piggieback "0.2.1"]]
                    :repl-options {:nrepl-middleware [cemerick.piggieback/wrap-cljs-repl]}}})
