(ns burningswell.config.test
  (:require [burningswell.config.core :as core]
            [burningswell.config.schema :refer :all]
            [environ.core :as env]
            [schema.core :as s]))

(def env
  "The test environment."
  {:bs-api-bind-address "0.0.0.0"
   :bs-api-bind-port "22000"
   :bs-api-scheme "http"
   :bs-api-server-name "localhost"
   :bs-api-server-port "22000"
   :bs-api-ssl-redirect "false"
   :bs-aws-access-key "AWS-ACCESS-KEY"
   :bs-aws-account-number "AWS-ACCOUNT-NUMBER"
   :bs-aws-secret-key "AWS-SECRET-KEY"
   :bs-image-proxy-bind-address "0.0.0.0"
   :bs-image-proxy-bind-port "22002"
   :bs-image-proxy-scheme "http"
   :bs-image-proxy-backend-url "https://s3.amazonaws.com/burningswell-test"
   :bs-image-proxy-server-name "localhost"
   :bs-image-proxy-server-port "22002"
   :bs-broker-server-name "localhost"
   :bs-broker-server-port "5672"
   :bs-broker-username "tiger"
   :bs-broker-password "scotch"
   :bs-broker-vhost "burningswell.test"
   :bs-db-name "burningswell_test"
   :bs-db-password "scotch"
   :bs-db-rollback "true"
   :bs-db-scheme "postgresql"
   :bs-db-server-name "localhost"
   :bs-db-server-port "5432"
   :bs-db-user "tiger"
   :bs-facebook-client-id "FACEBOOK-CLIENT-ID"
   :bs-facebook-client-secret "FACEBOOK-CLIENT-SECRET"
   :bs-facebook-redirect-uri
   "http://api.burningswell.dev/oauth/facebook/callback"
   :bs-flickr-api-key "FLICKR-API-KEY"
   :bs-flickr-client-id "FLICKR-CLIENT-ID"
   :bs-flickr-client-secret "FLICKR-CLIENT-SECRET"
   :bs-google-api-key "GOOGLE-API-KEY"
   :bs-google-client-id "GOOGLE-CLIENT-ID"
   :bs-google-client-secret "GOOGLE-CLIENT-SECRET"
   :bs-google-redirect-uri "http://api.burningswell.dev/oauth/google/callback"
   :bs-google-maps-api-key
   (:bs-google-maps-api-key env/env "GOOGLE-MAPS-API-KEY")
   :bs-jws-secret "secret"
   :bs-reload-disabled "true"
   :bs-s3-backup-bucket "burningswell-test"
   :bs-s3-backup-prefix "backups"
   :bs-s3-photo-bucket "burningswell-test"
   :bs-s3-photo-prefix "photos"
   :bs-web-bind-address "0.0.0.0"
   :bs-web-bind-port "22001"
   :bs-web-scheme "http"
   :bs-web-server-name "localhost"
   :bs-web-server-port "22001"
   :bs-web-ssl-redirect "false"})

(s/defn ^:always-validate config :- Config
  "Return the test config."
  [& [opts]]
  (core/config (merge env opts)))
