(ns burningswell.config.schema
  (:require [schema.core :as s]))

(def Api
  "The schema for the API service."
  {:ip s/Str
   :port s/Int
   :scheme (s/enum :http :https)
   :server-name s/Str
   :server-port s/Int})

(def Aws
  "The schema for the AWS service."
  {:access-key s/Str
   :account-number s/Str
   :secret-key s/Str})

(def Db
  "The schema for the database service."
  {:name s/Str
   :password s/Str
   :scheme (s/enum :postgresql)
   :server-name s/Str
   :server-port s/Int
   :username s/Str})

(def Facebook
  "The schema for the Facebook service."
  {:client-id s/Str
   :client-secret s/Str
   :redirect-uri s/Str})

(def Flickr
  "The schema for the Flickr service."
  {:client-id s/Str
   :client-secret s/Str})

(def Google
  "The schema for the database service."
  {:client-id s/Str
   :client-secret s/Str
   :redirect-uri s/Str})

(def Web
  "The schema for the web service."
  {:ip s/Str
   :port s/Int
   :scheme (s/enum :http :https)
   :server-name s/Str
   :server-port s/Int})

(def Config
  "The schema for the config."
  {:api Api
   :aws Aws
   :db Db
   :facebook Facebook
   :flickr Flickr
   :google Google
   :web Web})
