(ns burningswell.config.core
  (:require [burningswell.config.schema :as schemas]
            [schema.core :as s]
            [clojure.edn :as edn]))

(s/defn ^:always-validate api :- schemas/Api
  "Return the api config from `env`."
  [env]
  {:ip (:api-bind-address env)
   :port (edn/read-string (:api-bind-port env))
   :scheme (keyword (:api-scheme env))
   :server-name (:api-server-name env)
   :server-port (edn/read-string (:api-server-port env))})

(s/defn ^:always-validate aws :- schemas/Aws
  "Return the AWS config from `env`."
  [env]
  {:access-key (:aws-access-key env)
   :account-number (:aws-account-number env)
   :secret-key (:aws-secret-key env)})

(s/defn ^:always-validate db :- schemas/Db
  "Return the database config from `env`."
  [env]
  {:name (:db-name env)
   :password (:db-password env)
   :scheme (keyword (:db-scheme env))
   :server-name (:db-server-name env)
   :server-port (edn/read-string (:db-server-port env))
   :username (:db-username env)})

(s/defn ^:always-validate facebook :- schemas/Facebook
  "Return the Facebook config from `env`."
  [env]
  {:client-id (:facebook-client-id env)
   :client-secret (:facebook-client-secret env)
   :redirect-uri (:facebook-redirect-uri env)})

(s/defn ^:always-validate flickr :- schemas/Flickr
  "Return the Flickr config from `env`."
  [env]
  {:client-id (:flickr-client-id env)
   :client-secret (:flickr-client-secret env)})

(s/defn ^:always-validate google :- schemas/Google
  "Return the Google config from `env`."
  [env]
  {:client-id (:google-client-id env)
   :client-secret (:google-client-secret env)
   :redirect-uri (:google-redirect-uri env)})

(s/defn ^:always-validate web :- schemas/Web
  "Return the web config from `env`."
  [env]
  {:ip (:web-bind-address env)
   :port (edn/read-string (:web-bind-port env))
   :scheme (keyword (:web-scheme env))
   :server-name (:web-server-name env)
   :server-port (edn/read-string (:web-server-port env))})

(s/defn ^:always-validate config :- schemas/Config
  "Return the system config from `env`."
  [env]
  {:api (api env)
   :aws (aws env)
   :db (db env)
   :facebook (facebook env)
   :flickr (flickr env)
   :google (google env)
   :web (web env)})
