(ns burningswell.config
  (:require [clojure.edn :as edn]))

(defn api
  "Return the api config from `env`."
  [env]
  {:ip (:api-bind-address env)
   :port (edn/read-string (:api-bind-port env))
   :scheme (keyword (:api-scheme env))
   :server-name (:api-server-name env)
   :server-port (edn/read-string (:api-server-port env))})

(defn web
  "Return the web config from `env`."
  [env]
  {:ip (:web-bind-address env)
   :port (edn/read-string (:web-bind-port env))
   :scheme (keyword (:web-scheme env))
   :server-name (:web-server-name env)
   :server-port (edn/read-string (:web-server-port env))})

(defn config
  "Return the system config from `env`."
  [env]
  {:api (api env)
   :web (web env)})
