(ns burningswell.api.authentication
  (:require [buddy.auth.backends.httpbasic :refer [http-basic-backend]]
            [buddy.auth.backends.token :refer [jws-backend]]
            [buddy.auth.middleware :as middleware]
            [burningswell.db.users :as users]
            [io.pedestal.interceptor :refer [interceptor]]))

(defn- http-basic-auth-fn
  "The HTTP basic authentication fn."
  [request credentials]
  (users/authenticate (:db request) credentials))

(def authentication-interceptor
  (interceptor
   {:name ::authentication-interceptor
    :enter
    (fn [context]
      (let [jwt-secret (-> context :request :config :jwt :secret)]
        (->> (#'middleware/authenticate-request
              (:request context)
              [(http-basic-backend
                {:realm "Burning Swell API"
                 :authfn http-basic-auth-fn})
               (jws-backend {:secret jwt-secret})])
             (assoc-in context [:request :identity]))))}))
