(ns burningswell.api.system
  (:require [burningswell.api.client :as api]
            [burningswell.api.server :as server]
            [burningswell.api.topology :refer [new-topology]]
            [burningswell.db.connection :refer [new-db]]
            [burningswell.geoip.maxmind :as geoip]
            [burningswell.metrics.core :as metrics]
            [burningswell.namespace :refer [new-reload]]
            [burningswell.rabbitmq.core :refer [rabbitmq]]
            [com.stuartsierra.component :as component]))

(defn new-system
  "Return a new API system."
  [config]
  (let [{:keys [api-client broker db reload]} config]
    (component/system-map
     :api (server/new-api config)
     :api-client (api/new-client api-client)
     :broker (rabbitmq broker)
     :config config
     :db (new-db db)
     :geoip (geoip/database)
     :metrics (metrics/metrics)
     :reload (new-reload reload)
     :topology (new-topology {}))))

(defmacro with-system
  "Evaluate `body` within the context of a running API system."
  [[symbol config] & body]
  `(let [system# (new-system ~config)
         system# (component/start system#)
         ~symbol system#]
     (try ~@body
          (finally (component/stop system#)))))
