(ns burningswell.api.server
  (:require [burningswell.api.interceptors :refer [add-interceptors]]
            [burningswell.api.routes :refer [routes]]
            [burningswell.pedestal.server :refer [server]]
            [com.stuartsierra.component :as component]
            [io.pedestal.http :as http]))

(def dependencies
  "The API server component dependencies."
  [:api-client :broker :config :db :geoip :metrics :topology])

(defn new-api
  "Return a new API server."
  [& [config]]
  (-> (assoc config
             ::http/router :linear-search
             :routes #(deref #'routes)
             :init add-interceptors)
      (server)
      (component/using dependencies)))
