(ns burningswell.api.validation
  (:require [burningswell.api.errors :as errors]
            [burningswell.api.spec.context :refer [with-context]]))

(defn validate-data
  [context spec data]
  (with-context context
    (errors/explain-data spec data)))

(defn validate-errors
  [context spec data]
  (with-context context
    (errors/explain-errors spec data)))

(defn validate-errors!
  [context spec data]
  (with-context context
    (let [errors (errors/explain-errors spec data)]
      (if (empty? errors)
        data
        (throw (ex-info "Validation error"
                        {:type :validation-error
                         :data data
                         :errors errors}))))))
