(ns burningswell.api.spec.spot
  (:require [burningswell.api.spec.core :as core :refer :all]
            [burningswell.api.spec.context :refer [*context*]]
            [burningswell.api.spec.generators :as gen]
            [burningswell.api.spec.country :as country]
            [burningswell.api.spec.region :as region]
            [burningswell.db.spots :as spots]
            [clojure.spec :as s]))

(s/def ::id
  (s/and pos-int?))

(s/def ::name
  (s/and string?
         not-blank?
         (min-length 2)
         (max-length 256)))

(s/def ::country (s/nilable ::country/embedded))

(s/def ::region (s/nilable ::region/embedded))

(s/def ::_embedded
  (s/keys :opt-un [::country ::region]))

(s/def ::spot
  (s/keys :req-un [::name ::_embedded]
          :opt-un [::visible]))

(defn location-available?
  "Returns true if the location of spot `id` can be changed to
  `location`, otherwise false."
  [{:keys [id location] :as spot}]
  (spots/location-available?
   (:db *context*) location {:exclude (when id [id])}))

(s/def ::visible
  #{"public" "private"})

(s/def ::create-spot-data
  (s/keys :req-un [::name ::core/location]
          :opt-un [::_embedded
                   ::visible]))

(s/def ::create-spot
  (s/and ::create-spot-data
         location-available?))

(s/def ::update-spot-data
  (s/keys :req-un [::id ::name ::core/location]
          :opt-un [::_embedded
                   ::visible]))

(s/def ::update-spot
  (s/and ::update-spot-data
         location-available?))
