(ns burningswell.api.map
  (:refer-clojure :exclude [map])
  (:require [burningswell.db.countries :as countries]
            [burningswell.db.regions :as regions]
            [burningswell.db.spots :as spots]
            [burningswell.http.response :refer [ok]]))

(defn map
  "Return countries, regions or spots based on the map zoom level."
  [{:keys [api-client db query-params]}]
  (let [{:keys [zoom]} query-params]
    (ok (cond
          (or (nil? zoom) (< zoom 6))
          (->> (countries/all db query-params)
               (countries/assoc-photo db)
               (mapv #(assoc % :type :country)))
          (< zoom 8)
          (->> (regions/all db query-params)
               (regions/assoc-photo db)
               (mapv #(assoc % :type :region)))
          :else
          (->> (spots/all db query-params)
               (spots/assoc-photo db)
               (mapv #(assoc % :type :spot)))))))
