(ns burningswell.api.i18n
  (:require [tongue.core :as tongue]))

(def dicts
  {:en
   {:contains? "must be provided"
    :email "Email"
    :email-available? "That email is already being used"
    :id "Identifier"
    :invalid-email "Invalid email address"
    :invalid-visibility "Visibility must be \"public\" or \"private\""
    :location "Location"
    :max-length "is too long (max. {1} chars)"
    :min-length "is too short (min. {1} chars)"
    :must-be "must be"
    :name "Name"
    :not-blank? "can't be blank"
    :not-string "must be a string"
    :or "or"
    :password "Password"
    :point? "must be a geographic point"
    :pos-int? "must be a positive number"
    :units? "Invalid units, must be \"eu\", \"uk\" or \"us\""
    :unknown-error "Unknown error"
    :username "Username"
    :username-available? "That username is already being used"

    :burningswell.api.spec.core
    {:location "Location"}

    :burningswell.api.spec.user
    {:email "Email"
     :units "Units"
     :username "Username"
     :password "Password"}

    :burningswell.api.spec.spot
    {:id "Identifier"
     :name "Name"
     :location-taken "There's already a spot at that location"
     :visible "Visibility"}}

   :tongue/fallback :en})

(def t (tongue/build-translate dicts))
