(ns burningswell.api.main
  (:require [burningswell.config.core :as config]
            [burningswell.api.system :refer [new-system]]
            [burningswell.system :as system]
            [com.stuartsierra.component :as component]
            [environ.core :refer [env]])
  (:gen-class))

(defn -main [& args]
  (system/with-system [system (new-system (config/api env))]
    (system/on-shutdown #(component/stop system))
    (loop []
      (Thread/sleep 10000)
      (recur))))
