(ns burningswell.api.core
  (:require [burningswell.rabbitmq.core :as rmq]
            [schema.core :as s])
  (:import [burningswell.rabbitmq.core RabbitMQ]))

(s/defn publish
  "Publish a message with `payload` to the API exchange using
  `routing-key`. "
  [broker :- RabbitMQ
   routing-key :- String
   payload :- s/Any & [opts]]
  (rmq/with-channel [channel broker]
    (rmq/publish channel "api" routing-key payload opts)))
