(defproject burningswell/api "0.2.1"
  :description "The Burning Swell API"
  :url "https://bitbucket.org/burningswell/api"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :min-lein-version "2.0.0"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[buddy/buddy-auth "1.1.0"]
                 [burningswell/api-client "0.0.45"]
                 [burningswell/config "0.1.31"]
                 [burningswell/core "0.0.40"]
                 [burningswell/db "0.0.76"]
                 [burningswell/http-server "0.1.10"]
                 [burningswell/rabbitmq "0.1.10"]
                 [ch.qos.logback/logback-classic "1.1.7"]
                 [clj-http-fake "1.0.2"]
                 [funcool/clojure.jdbc "0.9.0"]
                 [geo-clj "0.6.0"]
                 [hal-clj "0.1.12"]
                 [hiccup "1.0.5"]
                 [io.pedestal/pedestal.jetty "0.5.1-SNAPSHOT"]
                 [io.pedestal/pedestal.service "0.5.1-SNAPSHOT"]
                 [org.clojure/clojure "1.8.0"]
                 [org.clojure/core.cache "0.6.5"]
                 [org.omcljs/om "1.0.0-alpha36"]
                 [prismatic/schema "1.1.2"]
                 [rm-hull/inkspot "0.2.1"]
                 [routes-clj "0.1.10"]]
  :plugins [[lein-environ "1.0.3"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]}
  :eastwood {:config-files ["test-resources/eastwood.clj"]
             :exclude-linters [:deprecations :local-shadows-var]}
  :main ^{:skip-aot true} burningswell.api.main
  :profiles {:dev {:dependencies [[reloaded.repl "0.2.2"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-cloverage "1.0.6"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]}
             :repl {:repl-options {:init-ns user}
                    :source-paths ["dev"]}
             :test {:env {:bs-db-name "burningswell_test"
                          :bs-db-password "scotch"
                          :bs-db-scheme "postgresql"
                          :bs-db-server-name "localhost"
                          :bs-db-server-port "5432"
                          :bs-db-user "tiger"}
                    :resource-paths ["test-resources"]}
             :uberjar {:aot :all :main burningswell.api.main}}
  :uberjar-name "burningswell-api.jar")
