(ns burningswell.api.server
  (:require [burningswell.api.interceptors :refer [add-interceptors]]
            [burningswell.api.routes :refer [routes]]
            [com.stuartsierra.component :as component]
            [io.pedestal.http :as http]
            [io.pedestal.http.route :as route]))

(defrecord Pedestal []
  component/Lifecycle
  (start [server]
    (-> (add-interceptors server)
        (http/create-server)
        (http/start)))
  (stop [server]
    (http/stop server)))

(defn new-api
  "Return a new API server."
  [& [config]]
  (-> {:env :dev
       ::http/allowed-origins {:creds true :allowed-origins (constantly true)}
       ::http/join? false
       ::http/port (:bind-port config)
       ::http/resource-path "/public"
       ::http/routes #(deref #'routes)
       ::http/type :jetty}
      http/default-interceptors
      ;; http/dev-interceptors
      (map->Pedestal)
      (component/using [:api-client :broker :config :db :topology])))
