(ns burningswell.api.search
  (:require [burningswell.api.core :as core]
            [burningswell.api.middleware.commands :as commands]
            [burningswell.api.middleware.conform :as conform]
            [burningswell.api.middleware.events :as events]
            [burningswell.db.search :as search]
            [claro.data :as data]
            [clojure.spec.alpha :as s]))

(s/def :burningswell.api.searchs/params
  (s/keys :opt-un [:burningswell.api.pagination/after
                   :burningswell.api.pagination/before
                   :burningswell.api.pagination/first
                   :burningswell.api.pagination/last
                   :burningswell.api.search/min-spots
                   :burningswell.api.search/query
                   :burningswell.api.specs/distance
                   :burningswell.api.specs/location]))

(defrecord Search [after before distance first last location min-spots sort query]
  commands/Command
  (command [params env]
    {:name :burningswell.api.commands/search
     :params params})

  conform/Params
  (conform [params env]
    :burningswell.api.searchs/params)

  data/Mutation
  data/Resolvable
  (resolve! [params {:keys [db]}]
    (->> {:limit (core/limit params)
          :min-spots min-spots
          :offset (core/offset params)
          :query query}
         (search/search db)))

  events/Events
  (events [resolvable {:keys [user]} results]
    [{:name :burningswell.api.events/search-results
      :user-id (:id user)
      :results results}]))
