(ns burningswell.api.roles
  (:require [burningswell.api.core :as core]
            [burningswell.api.middleware.conform :as conform]
            [burningswell.api.middleware.identifier :as identifier]
            [burningswell.db.roles :as roles]
            [burningswell.db.util :refer [fulltext]]
            [claro.data :as data]
            [clojure.spec.alpha :as s]
            [datumbazo.core :as sql]))

(s/def :burningswell.api.roles/params
  (s/keys :opt-un [:burningswell.api.pagination/after
                   :burningswell.api.pagination/before
                   :burningswell.api.pagination/first
                   :burningswell.api.pagination/last
                   :burningswell.api.specs/direction
                   :burningswell.api.search/query
                   :burningswell.api.roles/sort]))

(defrecord Role [id name country region]
  conform/Params
  (conform [params env]
    (s/keys :req-un [:burningswell.api.specs/id]))

  identifier/Identifier
  (identifier [_ _]
    {:type :role
     :columns [:id]})

  data/Resolvable
  data/BatchedResolvable
  (resolve-batch! [_ {:keys [db]} roles]
    (roles/select-batch db roles)))

(defrecord Roles [after before first direction last sort query]
  conform/Params
  (conform [params env]
    :burningswell.api.roles/params)

  data/Resolvable
  (resolve! [params {:keys [db]}]
    (->> {:direction direction
          :limit (core/limit params)
          :offset (core/offset params)
          :query query
          :sort sort}
         (roles/search db))))
