(defproject burningswell/api "0.1.6"
  :description "The Burning Swell GraphQL server."
  :url "https://gitlab.com/burningswell/api"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "https://creativecommons.org/licenses/by-nc/3.0/"}
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[aleph "0.4.7-alpha5"]
                 [alumbra "0.2.6"]
                 [alumbra/ring "0.1.3"]
                 [alumbra/spec "0.1.11"]
                 [alumbra/web "0.1.0-20170526.083939-2"]
                 [buddy/buddy-auth "2.1.0"]
                 [burningswell/config "0.1.63"]
                 [burningswell/core "0.0.89"]
                 [burningswell/db "0.3.61"]
                 [fundingcircle/jackdaw "0.6.3"
                  :exclusions [io.confluent/kafka-avro-serializer
                               io.confluent/kafka-connect-avro-converter
                               io.confluent/kafka-connect-jdbc
                               io.confluent/kafka-schema-registry
                               io.confluent/kafka-schema-registry-client
                               org.apache.kafka/connect-api
                               org.apache.kafka/connect-json
                               org.apache.kafka/connect-runtime
                               org.apache.kafka/kafka-streams
                               org.apache.kafka/kafka_2.11]]
                 [burningswell/specs "0.1.12"]
                 [burningswell/transit "0.1.3"]
                 [ch.qos.logback/logback-core "1.2.3"]
                 [ch.qos.logback/logback-classic "1.2.3"]
                 [claro/access "0.1.0"]
                 [clj-http "3.9.1"]
                 [com.taoensso/timbre "4.10.0"]
                 [grafeo "0.1.4"]
                 [iapetos "0.1.8"]
                 [io.prometheus/simpleclient_hotspot "0.6.0"]
                 [oauth/oauth.one "0.7.0"]
                 [org.clojure/clojure "1.10.1-beta3"]
                 [peripheral "0.5.3"]
                 [phrase "0.3-alpha4"]
                 [ring-cors "0.1.13"]
                 [ring-middleware-format "0.7.4"]]
  :plugins [[lein-environ "1.1.0"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["eastwood"]]}
  :eastwood {:config-files ["test-resources/eastwood.clj"]
             :exclude-linters [:local-shadows-var :implicit-dependencies]}
  :main ^{:skip-aot true} burningswell.api.main
  :profiles {:dev {:dependencies [[alumbra/generators "0.2.2"]
                                  [mvxcvi/test.carly "0.4.1"]
                                  [org.clojure/test.check "0.9.0"]
                                  [reloaded.repl "0.2.4"]]
                   :plugins [[jonase/eastwood "0.3.5"]
                             [lein-cloverage "1.1.1"]
                             [lein-difftest "2.0.0"]]}
             :repl {:repl-options {:init-ns user}
                    :source-paths ["dev"]}
             :test {:resource-paths ["test-resources"]}
             :uberjar {:aot :all
                       :main burningswell.api.main
                       :resource-paths ["uberjar-resources"]}}
  :repositories [["confluent" "https://packages.confluent.io/maven/"]]
  :uberjar-name "burningswell-api.jar")
