(ns burningswell.api.middleware.exceptions
  (:require [claro.data :as data]
            [claro.engine :as engine]
            [manifold.deferred :as d]
            [taoensso.timbre :as log]))

(defn- default-error-response
  "Returns the default error response for `exception` in the given `batch`."
  [exception batch]
  (log/error exception)
  (let [error (data/error (.getMessage exception) (ex-data exception))]
    (->> (for [resolveable batch] [resolveable error])
         (into {}))))

(defmulti handle-exception
  "Handle the `exception` for the given `batch`."
  (fn [exception batch]
    (-> exception ex-data :type)))

(defmethod handle-exception :default [exception batch]
  (log/error exception)
  (.printStackTrace exception)
  (if (instance? clojure.lang.ExceptionInfo exception)
    (default-error-response exception batch)
    (throw exception)))

(defn wrap-exceptions
  "Middleware that handles exceptions from GraphQL resolvers. Handles
  regular exceptions and deferred ones."
  [engine]
  (->> (fn [resolver]
         (fn [env batch]
           (d/catch
               (try
                 (resolver env batch)
                 (catch Exception e
                   (handle-exception e batch)))
               #(handle-exception %1 batch))))
       (engine/wrap engine)))
