(ns burningswell.api.weather.datasources
  (:require [burningswell.api.middleware.conform :as conform]
            [burningswell.api.middleware.identifier :as identifier]
            [burningswell.db.weather.datasources :as datasources]
            [claro.data :as data]
            [clojure.spec.alpha :as s]
            [datumbazo.core :as sql]))

(s/def :burningswell.api.weather.datasources/params
  (s/keys :opt-un [:burningswell.api.pagination/after
                   :burningswell.api.pagination/before
                   :burningswell.api.pagination/first
                   :burningswell.api.pagination/last
                   :burningswell.api.search/query
                   :burningswell.api.specs/direction
                   :burningswell.api.weather.datasources/sort]))

(defrecord Datasource [id name description]
  conform/Params
  (conform [params env]
    (s/keys :req-un [:burningswell.api.specs/id]))

  identifier/Identifier
  (identifier [_ _]
    {:type :weather-datasource
     :columns [:id]})

  data/Resolvable
  data/BatchedResolvable
  (resolve-batch! [_ {:keys [db]} datasources]
    (datasources/select-batch db datasources)))

(defrecord Datasources [after before direction first last sort query]
  conform/Params
  (conform [params env]
    :burningswell.api.weather.datasources/params)

  data/Resolvable
  (resolve! [_ {:keys [db]}]
    @(sql/select db [:datasources.id]
       (sql/from :weather.datasources)
       ;; (fulltext query :name :description)
       (sql/limit first)
       (sql/order-by (keyword (or sort :id))))))
