(ns burningswell.api.system
  (:require [burningswell.api.client :as client]
            [burningswell.api.jwt :as jwt]
            [burningswell.api.logger :as logger]
            [burningswell.api.metrics :as metrics]
            [burningswell.api.publisher :as publisher]
            [burningswell.api.server :as server]
            [burningswell.db.connection :as db]
            [com.stuartsierra.component :as component]))

(defn system
  "Return a new system."
  [{:keys [api-client db logger kafka jwt web worker] :as config}]
  (component/system-map
   :client (client/client api-client)
   :db (db/new-db db)
   :jwt (jwt/jwt jwt)
   :logger (logger/logger {:level :info})
   :metrics (metrics/metrics)
   :publisher (publisher/kafka kafka)
   :server (server/server config)
   :web web))
