(ns burningswell.api.middleware.identifier
  (:require [claro.engine :as engine]
            [claro.runtime.impl :as impl]
            [potemkin :refer [defprotocol+]]
            [ring.util.codec :as codec]))

(defprotocol+ Identifier
  (identifier [resolvable env]))

(extend-type Object
  Identifier
  (identifier [resolvable env]
    nil))

;; Transform output identifiers

(defn- make-id [result type columns]
  (-> (select-keys result columns)
      (assoc :type type)
      (pr-str)
      (.getBytes)
      (codec/base64-encode)))

(defn- assoc-id [result type columns]
  (when-not (empty? result)
    (assoc result :id (make-id result type columns))))

(defn- transform-output
  [resolvable->result env]
  (->> (for [[resolvable result] resolvable->result
             :let [{:keys [type columns]} (identifier resolvable env)]]
         [resolvable
          (if (and type (not-empty columns))
            (assoc-id result type columns)
            result)])
       (into {})))

(defn wrap-output
  [engine]
  (let [impl (engine/impl engine)]
    (->> (fn [resolver]
           (fn [env batch]
             (impl/chain1
              impl
              (resolver env batch)
              #(transform-output % env))))
         (engine/wrap-transform engine))))
