(ns burningswell.api.locations
  (:require [claro.data :as data]))

(defrecord Location [point]
  data/Cost
  (cost [_ _]
    0)

  data/Resolvable
  (resolve! [_ _]
    (cond
      (nil? point)
      nil
      (and (:latitude point)
           (:longitude point))
      point
      (instance? org.postgis.Point point)
      {:latitude (.getY point)
       :longitude (.getX point)})))
