(ns burningswell.api.images
  (:require [burningswell.api.core :as core]
            [clojure.spec.alpha :as s]
            [burningswell.db.images :as images]
            [burningswell.api.middleware.conform :as conform]
            [burningswell.api.middleware.identifier :as identifier]
            [burningswell.api.specs :as specs]
            [claro.data :as data]
            [clojure.spec.alpha :as s]
            [datumbazo.core :as sql]))

(s/def :burningswell.api.images/params
  (s/keys :opt-un [:burningswell.api.images/sort
                   :burningswell.api.pagination/after
                   :burningswell.api.pagination/before
                   :burningswell.api.pagination/first
                   :burningswell.api.pagination/last
                   :burningswell.api.search/query
                   :burningswell.api.specs/direction]))

(defrecord Image [id width height]
  conform/Params
  (conform [params env]
    (s/keys :req-un [:burningswell.api.specs/id]))

  identifier/Identifier
  (identifier [_ _]
    {:type :image
     :columns [:id]})

  data/Resolvable
  data/BatchedResolvable
  (resolve-batch! [_ {:keys [db]} images]
    (images/select-batch db images)))

(defrecord Images [after before direction first last sort query]
  conform/Params
  (conform [params env]
    :burningswell.api.images/params)

  data/Resolvable
  (resolve! [params {:keys [db]}]
    (->> {:direction direction
          :limit (core/limit params)
          :offset (core/offset params)
          :query query
          :sort sort}
         (images/search db))))
