(ns burningswell.api.topology
  (:require [burningswell.rabbitmq.core :as rabbitmq]
            [com.stuartsierra.component :as component]
            [clojure.tools.logging :as log]))

(defn start-topology
  "Start message broker topology."
  [{:keys [broker] :as topology}]
  (if (:started topology)
    topology
    (rabbitmq/with-channel [channel broker]
      (rabbitmq/declare-exchange channel "api" "topic" {:durable true})
      (log/infof "Started message broker topology.")
      (assoc topology :started true))))

(defrecord Topology [broker]
  component/Lifecycle
  (start [topology]
    (start-topology topology))
  (stop [topology]
    (dissoc topology :started)))

(defn new-topology
  "Return a new rabbitmq topology."
  [config]
  (map->Topology config))
